// config: norepeat

#include "GetObjects.js"
#include "GetDistance.js"

function DoArrayGem()
{
	var ui = moi.ui;
	var objectpicker = ui.createObjectPicker();

	
	// Get the objects to array.
	
	if ( !GetObjects( objectpicker ) )
		return;
		
	var objects = objectpicker.objects;
	objects.sortBySelectionOrder();

	// Next get the path curves and optional surface.
	
	ui.beginUIUpdate();
	ui.hideUI( 'SelectObjectsPrompt' );
	ui.showUI( 'SelectPathPrompt' );
	ui.endUIUpdate();
	
	objectpicker.allowCurves();
	objectpicker.allowBReps();
	objectpicker.allowPointObjects();
	if ( !GetObjects( objectpicker ) )
		return;
		
	var paths = objectpicker.objects;
	paths.sortBySelectionOrder();

	var factory = moi.command.createFactory( 'arraygem' );
	factory.setInput( 0, objects );	
	factory.setInput( 1, paths );

	// Now get options.

	if ( paths.numCurves > 0 )
	{
		ui.beginUIUpdate();
		ui.hideUI( 'SelectPathPrompt' );
		ui.showUI( 'OptionsPrompt' );
		ui.showUI( 'Options' );
		ui.endUIUpdate();
	
		if ( !GetDistance( factory, 2, 'spacing', {allowzero:true} ) )
			return;
	}

	factory.commit();
}

DoArrayGem();
